// ==========================================================================
//
// = LIBRARY
//     PCIEFPGA
// 
// = FILENAME
//     pciefpgacsspc.cpp
// 
// = COPYRIGHT
//     (C) Copyright 2005 Agilent Technologies
//
// ==========================================================================
#include "PCIEFPGACSSpc.h"
#include "devpcieintdefs.h"
#include "AgtPCIEControl.h"
#include "PCIETLPInfo.h"

#define FPGARXMISC_SICOMPLPAYLOAD_DWNUM     ((UInt8) 4) // DWords
#define FPGARXMISC_SIHEADER_DWNUM           ((UInt8) 4) // DWords


//***************************************************************************
CPCIEFpgaCSSpc::CPCIEFpgaCSSpc()
{
  mSiComplStatus     = PCIE_FPGA_CSSPC_OFFSET + PCIE_FPGAOFFSET_CSSPC_SICOMPLSTATUS;
  mSiComplHeaderDw0  = PCIE_FPGA_CSSPC_OFFSET + PCIE_FPGAOFFSET_CSSPC_SICOMPLHEADERDW0;
  mSiComplPayloadDW0 = PCIE_FPGA_CSSPC_OFFSET + PCIE_FPGAOFFSET_CSSPC_SICOMPLPAYLOADDW0;

  myController=new CAgtPCIEControl(); // returns only pointer if instance exists
}

CPCIEFpgaCSSpc::~CPCIEFpgaCSSpc()
{
  delete myController;
  myController = NULL;
}

//
// register wrappers
//


// -----------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::getSiComplStatus(const AgtPortHandleT& portHandle)
{
  UInt32 val;
  myController->FPGARead(portHandle,mSiComplStatus,val);
  return val;
}

// -----------------------------------------------------------------------
void
CPCIEFpgaCSSpc::setSiComplStatus(const AgtPortHandleT& portHandle, const UInt32& val)
{
  myController->FPGAWrite(portHandle,mSiComplStatus,val);
}

//
// functions
//
// -----------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::getSiComplHeaderDw(const AgtPortHandleT& portHandle, const UInt8& idx)
{
  UInt32 val = 0;

  if(idx < FPGARXMISC_SIHEADER_DWNUM)
  {
    UInt32 address = mSiComplHeaderDw0+(idx * 4); 
    myController->FPGARead(portHandle,address,val);
  }
  else
  {
    AGT_THROW("Invalid index");
  }

  return val;
}

// -----------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::getSiComplPayloadDW(const AgtPortHandleT& portHandle, const UInt8& idx)
{
  UInt32 val = 0;

  if(idx < FPGARXMISC_SICOMPLPAYLOAD_DWNUM)
  {
    UInt32 address = mSiComplPayloadDW0+(idx * 4); 
    myController->FPGARead(portHandle,address,val);
  }
  else
  {
    AGT_THROW("Invalid index");
  }

  return val;
}

// -----------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::getSiComplHeaderProp(const AgtPortHandleT& portHandle, const EPCIESi& prop)
{
  UInt8 hIdx = CPCIETlpInfo::getDWNum(prop);
  
  UInt32 hVal = getSiComplHeaderDw(portHandle, hIdx);

  return CPCIETlpInfo::getPropVal(prop,hVal);
}

// -----------------------------------------------------------------------
// HELPER 
// -----------------------------------------------------------------------

// -----------------------------------------------------------------------
void
CPCIEFpgaCSSpc::setBits(UInt32& val,const UInt8& bitPos,const UInt8& bitSize, const UInt32& bitVal)
{
  UInt32 mask;
  
  if(bitSize == 32)
  {
    val = bitVal;
  }
  else
  {
    mask = ((0x1 << bitSize) - 1);
    val &= ~(mask << bitPos);
    val |=  ((mask & bitVal) << bitPos);
  }
}
// -----------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::getBits(const UInt32& val,const UInt8& bitPos,const UInt8& bitSize)
{
  UInt32 mask;
  
  if(bitSize == 32)
  {
    return val;
  }
  else
  {
    mask = ((0x1 << bitSize) - 1);
    return (val >> bitPos) & mask;
  }
  return 0x0;
}


//---------------------------------------------------------------------------
UInt32
CPCIEFpgaCSSpc::swapDW(const UInt32& val)
{
  return ((val & 0xff) << 24) | ((val & 0xff00) << 8) | ((val & 0xff0000) >> 8) | ((val & 0xff000000) >> 24);
}
